/*
 * Decompiled with CFR 0.152.
 */
package org.garret.metronome;

import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import org.garret.metronome.Metronome;

public class SettingsForm
extends Form
implements CommandListener {
    Metronome metronome;
    Gauge frequency;
    Gauge duration;
    Gauge volume;
    ChoiceGroup flags;
    static final int MAX_FREQUENCY = 13288;
    static final int MAX_DURATION = 1000;
    static final int MAX_VOLUME = 255;

    SettingsForm(Metronome metronome) {
        super("Settings");
        this.metronome = metronome;
        this.frequency = new Gauge("Frequency", true, 13288, metronome.frequency);
        this.duration = new Gauge("Duration", true, 1000, metronome.duration);
        this.volume = new Gauge("Volume", true, 255, metronome.volume);
        this.flags = new ChoiceGroup("Signals", 2, new String[]{"Vibration", "Backlight"}, null);
        boolean[] blArray = new boolean[2];
        if ((metronome.flags & 1) != 0) {
            blArray[0] = true;
        }
        if ((metronome.flags & 2) != 0) {
            blArray[1] = true;
        }
        this.flags.setSelectedFlags(blArray);
        this.append((Item)this.frequency);
        this.append((Item)this.duration);
        this.append((Item)this.volume);
        this.append((Item)this.flags);
        this.addCommand(Metronome.SAVE_CMD);
        this.addCommand(Metronome.BACK_CMD);
        this.setCommandListener(this);
        Display.getDisplay((MIDlet)metronome).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Metronome.SAVE_CMD) {
            boolean[] blArray = new boolean[2];
            this.flags.getSelectedFlags(blArray);
            this.metronome.flags = 0;
            if (blArray[0]) {
                this.metronome.flags |= 1;
            }
            if (blArray[1]) {
                this.metronome.flags |= 2;
            }
            this.metronome.frequency = this.frequency.getValue();
            this.metronome.duration = this.duration.getValue();
            this.metronome.volume = this.volume.getValue();
            this.metronome.saveSettings();
            this.metronome.initSound();
        }
        Display.getDisplay((MIDlet)this.metronome).setCurrent((Displayable)this.metronome.canvas);
    }
}

