/*
 * Decompiled with CFR 0.152.
 */
package org.garret.metronome;

import com.nokia.mid.sound.Sound;
import com.nokia.mid.sound.SoundListener;
import com.nokia.mid.ui.DeviceControl;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import org.garret.metronome.HelpForm;
import org.garret.metronome.Metronome;
import org.garret.metronome.SettingsForm;

public class MetronomeCanvas
extends Canvas
implements CommandListener,
SoundListener {
    Metronome metronome;
    Timer timer;
    boolean seal;
    boolean on;
    long prevTime;
    int screenWidth;
    int screenHeight;
    TimerTask task;
    Font font;
    static final int WHITE = 0xFFFFFF;
    static final int BLACK = 0;
    static final int FREQ_STEP = 10;
    static final int INPUT_DELAY = 2000;
    static final int MAX_VIBRATION_FREQUENCY = 100;

    public void soundStateChanged(Sound sound, int n) {
        if (n == 1) {
            if (!this.seal) {
                this.on = false;
            }
            this.repaint();
        }
    }

    MetronomeCanvas(Metronome metronome) {
        this.metronome = metronome;
        this.timer = new Timer();
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.font = Font.getFont((int)0, (int)1, (int)16);
        this.setCommandListener(this);
        this.addCommand(Metronome.QUIT_CMD);
        this.addCommand(Metronome.SETTINGS_CMD);
        this.addCommand(Metronome.HELP_CMD);
        Display.getDisplay((MIDlet)metronome).setCurrent((Displayable)this);
        metronome.sound.setSoundListener((SoundListener)this);
        this.restart();
    }

    void restart() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.metronome.saveSettings();
        if (this.metronome.rate != 0) {
            this.task = new MetronomeTask();
            this.timer.scheduleAtFixedRate(this.task, 0L, (long)(60000 / this.metronome.rate));
        } else {
            this.repaint();
        }
    }

    protected void paint(Graphics graphics) {
        if (this.on) {
            graphics.setColor(0xFFFFFF);
            if ((this.metronome.flags & 2) != 0) {
                DeviceControl.setLights((int)0, (int)100);
            }
        } else {
            graphics.setColor(0);
            if ((this.metronome.flags & 2) != 0) {
                DeviceControl.setLights((int)0, (int)0);
            }
        }
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (!this.seal) {
            graphics.setFont(this.font);
            graphics.setColor(this.on ? 0 : 0xFFFFFF);
            String string = Integer.toString(this.metronome.rate);
            graphics.drawString(string, this.screenWidth / 2, this.screenHeight / 2, 65);
            this.on = false;
        }
    }

    public void keyReleased(int n) {
        if (n == 35) {
            this.seal = false;
            this.on = false;
            this.repaint();
        }
    }

    public void keyPressed(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.seal = false;
                long l = System.currentTimeMillis();
                this.metronome.rate = l - this.prevTime > 2000L ? n - 48 : this.metronome.rate * 10 + n - 48;
                this.prevTime = l;
                this.restart();
                break;
            }
            case 42: {
                if (this.on) {
                    this.seal = false;
                    this.on = false;
                } else {
                    this.seal = true;
                    this.on = true;
                }
                this.repaint();
                break;
            }
            case 35: {
                this.seal = true;
                this.on = true;
                this.repaint();
                break;
            }
            default: {
                switch (this.getGameAction(n)) {
                    case 2: {
                        if (this.metronome.rate <= 0) break;
                        --this.metronome.rate;
                        break;
                    }
                    case 5: {
                        ++this.metronome.rate;
                        break;
                    }
                    case 1: {
                        this.metronome.rate += 10;
                        break;
                    }
                    case 6: {
                        if (this.metronome.rate < 10) break;
                        this.metronome.rate -= 10;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.restart();
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Metronome.QUIT_CMD) {
            this.metronome.destroyApp(true);
            this.metronome.notifyDestroyed();
        } else if (command == Metronome.SETTINGS_CMD) {
            new SettingsForm(this.metronome);
        } else if (command == Metronome.HELP_CMD) {
            new HelpForm(this.metronome);
        }
    }

    class MetronomeTask
    extends TimerTask {
        MetronomeTask() {
        }

        public void run() {
            MetronomeCanvas.this.on = true;
            MetronomeCanvas.this.metronome.sound.play(1);
            if ((MetronomeCanvas.this.metronome.flags & 1) != 0) {
                try {
                    DeviceControl.startVibra((int)100, (long)MetronomeCanvas.this.metronome.duration);
                }
                catch (Exception exception) {
                    MetronomeCanvas.this.metronome.flags &= 0xFFFFFFFE;
                }
            }
            MetronomeCanvas.this.repaint();
        }
    }
}

