/*
 * Decompiled with CFR 0.152.
 */
package org.garret.metronome;

import com.nokia.mid.sound.Sound;
import com.nokia.mid.sound.SoundListener;
import javax.microedition.lcdui.Command;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import org.garret.metronome.MetronomeCanvas;

public class Metronome
extends MIDlet {
    static final Command QUIT_CMD = new Command("Quit", 2, 3);
    static final Command BACK_CMD = new Command("Back", 2, 2);
    static final Command SAVE_CMD = new Command("Save", 4, 1);
    static final Command SETTINGS_CMD = new Command("Settings", 8, 1);
    static final Command HELP_CMD = new Command("Help", 8, 2);
    int rate;
    int frequency;
    int duration;
    int volume;
    int flags;
    RecordStore store;
    Sound sound;
    public MetronomeCanvas canvas;
    public static Metronome instance;
    static final String STORE_NAME = "METRONOME";
    static final int RECORD_ID = 1;
    static final int VIBRA = 1;
    static final int BACKLIGHT = 2;
    static final int DEFAULT_FREQUENCY = 440;
    static final int DEFAULT_DURATION = 100;
    static final int DEFAULT_VOLUME = 255;
    static final int DEFAULT_FLAGS = 3;

    public Metronome() {
        instance = this;
        try {
            try {
                this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
                this.loadSettings();
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                this.initializeStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initSound();
    }

    void initSound() {
        this.sound = new Sound(this.frequency, (long)this.duration);
        this.sound.setGain(this.volume);
        if (this.canvas != null) {
            this.sound.setSoundListener((SoundListener)this.canvas);
        }
    }

    void loadSettings() {
        try {
            byte[] byArray = this.store.getRecord(1);
            this.frequency = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            this.duration = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
            this.rate = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
            this.volume = byArray[6] & 0xFF;
            this.flags = byArray[7];
        }
        catch (Exception exception) {
            this.initializeStore();
        }
    }

    void initializeStore() {
        this.frequency = 440;
        this.duration = 100;
        this.volume = 255;
        this.flags = 3;
        this.rate = 0;
        byte[] byArray = this.packSettings();
        try {
            this.store.addRecord(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void saveSettings() {
        byte[] byArray = this.packSettings();
        try {
            this.store.setRecord(1, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    byte[] packSettings() {
        byte[] byArray = new byte[]{(byte)(this.frequency >> 8), (byte)this.frequency, (byte)(this.duration >> 8), (byte)this.duration, (byte)(this.rate >> 8), (byte)this.rate, (byte)this.volume, (byte)this.flags};
        return byArray;
    }

    protected void destroyApp(boolean bl) {
        try {
            this.store.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        this.canvas = new MetronomeCanvas(this);
    }
}

